@extends('layouts.app')

@section('title', 'Login - Beautez Telehealth')

@section('content')
<div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-blue-500 to-blue-700">
    <div class="max-w-md w-full bg-white rounded-lg shadow-xl p-8">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-bold text-gray-800">Beautez Telehealth</h1>
            <p class="text-gray-600 mt-2">Sign in to your account</p>
        </div>

        <form method="POST" action="{{ route('login') }}">
            @csrf

            <div class="mb-4">
                <label for="email" class="block text-gray-700 text-sm font-bold mb-2">
                    Email Address
                </label>
                <input type="email" 
                       id="email" 
                       name="email" 
                       value="{{ old('email') }}"
                       required 
                       autofocus
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <div class="mb-6">
                <label for="password" class="block text-gray-700 text-sm font-bold mb-2">
                    Password
                </label>
                <input type="password" 
                       id="password" 
                       name="password" 
                       required
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <button type="submit" 
                    class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                Sign In
            </button>
        </form>

        <div class="mt-6 text-center">
            <p class="text-sm text-gray-600 mb-4">
                Don't have an account? 
                <a href="{{ route('doctor.register') }}" class="text-blue-600 hover:text-blue-800 font-semibold">
                    Register as Doctor
                </a>
                @if(\App\Models\Setting::get('patient_registration_enabled', false))
                    <span class="mx-2">|</span>
                    <a href="{{ route('patient.register') }}" class="text-blue-600 hover:text-blue-800 font-semibold">
                        Register as Patient
                    </a>
                @endif
            </p>
            <div class="text-sm text-gray-600">
                <p>Default credentials:</p>
                <p class="mt-2">Admin: admin@beautez.com / password</p>
                <p>Doctor: doctor@beautez.com / password</p>
                <p>Pharmacist: pharmacist@beautez.com / password</p>
            </div>
        </div>
    </div>
</div>
@endsection

